function PD_demo(casetype)
%PD_demo('TrimodalTIKR');
%PD_demo('TrimodalMEMwP0');
%PD_demo('TrimodalMEMwP0bal');
%PD_demo('Trimodal_bal');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
warning off all
switch (casetype)
    case{'TrimodalTIKR'}
        inp1=[1 15 60];
        PD_TIKR('Trimodal.dat',inp1);
    %
    case{'TrimodalMEMwP0'}
        inp1=[2 100 0.1 1];
    %Option: 2 (i.e. without considering baseline)
    %           See PD_MAXENT.m for details.
    %Number of the calculated regularization parameters (reg.): 200
    %The range of the reg. to search: [0.1 1]
        inp2=[15 60];
    %The range of the recovered P(r) in the unit of Angstrom: [15 60]
        PD_MAXENT('Trimodal.dat','TrimodalMEMwP0',inp1,inp2,...
            'pr0','TrimodalTIKR.pr0');
    %Perform Maximum Entropy calculations without considering baseline and
    % 1. Read in time-domain data, which is stored in 'Trimodal.dat'.
    % 2. Use 'TrimodalTKN.pr0' as initial P(r).
    % 3. Save the final result (e.g. P(r) vector) to the files, 'TrimodalMEMwP0.XX'.
    %Note: MEM calculation is a time-consuming process. It depends on how
    %many reg. parameters and the range you specify. As we suggested in our
    %MEM paper (JMR_177_2005_p184), perform several coarse-grained searches
    %to narrow down the range before doing fine-grained searches, e.g. 200
    %~ 500 reg. parameters.
    %
    %
    case{'TrimodalMEMwP0bal'}
        inp1=[4 100 0.1 1.5];
    %Option: 4 (i.e. considering a 2nd-degree poly baseline in time-domain data)
    %Number of the calculated singular values: 60
    %The range of the singular values to search: [0.1 1.5]
        inp2=[15 60];
    %The range of the recovered P(r) in the unit of Angstrom: [15 60]
        PD_MAXENT('Trimodal_bal.dat','TrimodalMEMwP0bal',inp1,inp2,...
            'pr0','TrimodalMEMwP0.pr0');
    %Perform Maximum Entropy calculations with baseline removal and
    % 1. Read in time-domain data, which is stored in 'Trimodal_bal.dat'.
    % 2. Use 'TrimodalMEMwP0.pr0' as initial values for P(r).
    % 3. Save the final result (i.e. P(r) vector) to the file, 'TrimodalMEMwP0bal.pr'.
    %
    %
    case{'Trimodal_bal'}
        PD_TIKRbal('Trimodal_bal.dat',[5 5],'poly2','no',[15 65]);
    %Perform TIKR and remove the baseline using the given function (e.g.
    %'expd') simultaneously. The best estimate for the solution vector P(r)
    %is saved in 'Trimodal_balTIKRbal.pr'. The
    %'Trimodal_balTIKRbal.pr0' contains the solution P(r) after
    %having the negative values corrected. The time-domain data after the removal of the
    %baseline is saved in 'Trimodal_balTIKRbal.S'. The estimated
    %baseline is saved in 'Trimodal_balTIKRbal.bal'.
    %
    %%
    %% See the following for further information of PD_TIKRbal.
    %%
    % The determination of Pair-Distributions by TIKhonov Regularization 
    % including the removal of the baseline function (PD_TIKRbal)
    % 
    % PD_TIKRbal(filnm,x_num,BType,coeff,inp);
    % On Input:
    % filnm= 'filename.dat' (raw time-domain data before the removal of baseline)
    % x_num= [xi xf] (respectively represents the number of points from left
    %                and right distance boundaries that you want them to be
    %                positive and close to zero) e.g. [5 5]
    % BType=   'expd' (baseline is assumed to be a exp decay) (DQC)
    %          'poly1'(1st-order poly) (DQC)
    %          'poly2'(2nd-order poly) (DQC)
    %          'poly3'(3rd-order poly) (DQC)
    % e.g. poly2 equation=p1*x^2+p2*x^1+p3
    %          'deerexpd' (baseline is assumed to be a exp decay) (DEER)
    %          'deerpoly1'(1st-order poly) (DEER)
    %          'deerpoly2'(2nd-order poly) (DEER)
    %          'deerpoly3'(3rd-order poly) (DEER)
    % coeff=   'yes' (the coefficients are manually assigned in the input vector, inp)
    %          'no'  (Let program determine the coefficients for the baseline.)
    % inp=[Rmin Rmax]; in unit of Angstrom
    %    or =[Rmin Rmax baseline_coeff]
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    otherwise
        error('invalid input');
end