c NLSL Version 1.5 beta 11/23/95
c----------------------------------------------------------------------
c                    =========================
c                       subroutine BASSQZ
c                    =========================
c
c   Manages memory space for storage of basis set indices. "Squeezes"
c   array ibasis by moving all stored basis sets to low end of the array.
c----------------------------------------------------------------------
      function bassqz()
      implicit none
      logical bassqz
c
      include 'nlsdim.inc'
      include 'basis.inc'
      include 'eprprm.inc'
      include 'expdat.inc'
      include 'prmeqv.inc'
      include 'parcom.inc'
      include 'stdio.inc'
c
      integer i,ib,ierr,in,ise,isi,ixb,j,k,maxb,lthd
c
c    ----------------------------------------------
c     First, determine which basis sets are in use
c    ----------------------------------------------
      do i=1,nbas
         bsused(i)=0
      end do
c
      do ise=1,nser
         do isi=1,nsite
            ib=basno(isi,ise) 
            if (ib.gt.0) bsused(ib)=1
         end do
      end do
c
c----------------------------------------------------------------------
c     Move all basis sets that are pruned or are in use to bottom
c     of storage array
c----------------------------------------------------------------------
      nextbs=1
      in=0
      do ib=1,nbas
         if (bsused(ib).gt.0 .or. pruned(ib).ne.0) then
            ixb=ixbas(ib)
            if (ixb.gt.nextbs) then
               do i=1,ltbas(ib)
                  k=ixb+i-1
                  do j=1,5
                     ibasis(j,nextbs)=ibasis(j,k)
                  end do
                  nextbs=nextbs+1
                  in=in+1
               end do
            else if (ixb.eq.nextbs) then
               nextbs=nextbs+ltbas(ib)
               in=in+1
            else
               write (luttyo,1000) ib,ixb,nextbs
               bassqz=.false.
               return
            end if
         end if
      end do
      nbas=in
c
      bassqz=.true.
      return
 1000 format('*** Error in basis storage: set',i2,' starts at',i5,
     #' but nextbs=',i5,' ***') 
      end


