/* **********************************************************************
 * file catch.c
 *
 ***********************************************************************/

#include <signal.h>
#include <stdio.h>
#define AIX

static long int *ctrlc_flag = NULL;
struct sigaction ctrlc_action, OldAction;


/***********************************************************************
 *
 *   ctrlc_handler: simple handler for receiving SIGINT signal
 *
 ***********************************************************************/
void ctrlc_handler( )

{
 *ctrlc_flag = 1;

/*  printf("\nUser interrupt pending...\n");
    fflush( stdout ); */
}



/* **********************************************************************
 *    subroutine catchc
 *
 *       Installs a control-C handler that sets iflag non-zero
 *       when CTRL-C is typed
 * 
 *       Calling sequence:   call catchc( iflag )
 *
 ***********************************************************************/

void catchc( long int *flag )
{
  *flag = 0;
  if (!ctrlc_flag) {
    ctrlc_flag = flag;

    ctrlc_handler;
#ifdef AIX
    ctrlc_action.sa_mask.losigs = 0;
    ctrlc_action.sa_mask.hisigs = 0;
#endif

    ctrlc_action.sa_flags = 0;
    sigaction( SIGINT, &ctrlc_action, &OldAction );
  }
}

/* **********************************************************************
 *
 * subroutine uncatchc()
 *
 *    Restores default action for handling SIGINT signal
 *
 ********************************************************************** */
void uncatchc(long int *flag )
{
  if (ctrlc_flag == flag) {
    *ctrlc_flag = 0;
    ctrlc_flag = NULL;
    sigaction( SIGINT, &OldAction, &ctrlc_action );
  }
}

