c NLSL Version 1.5 8/25/95
c----------------------------------------------------------------------
c                     =========================
c                        function KSTESTN
c                     =========================

      function kstestn(resid,n,rmean,rstd,iwork)
      implicit none
      integer n,iwork(n)
      double precision kstestn,resid(n),rmean,rstd
c
      integer i
      double precision absdev,dks,fn,pndtr,std2
c
      double precision probks
      external probks
c
c     First sort the residuals (only sort indices)
c
      call indexx(n,resid,iwork)
c
c     ------------------------------------------------------
c     Find the mean and standard deviation of the residuals
c     ------------------------------------------------------
c
      rmean=0.0d0
      fn=float(n)
      do i=1,n
         rmean=rmean+resid(i)
         rstd=rstd+resid(i)*resid(i)
      end do
      rmean=rmean/fn
      rstd=(rstd-fn*rmean*rmean)/(fn-1.0d0)
c
c     ------------------------------------------------------
c     Now search through the residuals and find
c     the largest deviation from a normal distribution that
c     has the same mean and standard deviation
c     ------------------------------------------------------

      std2=rstd*sqrt(2.0d0)
      dks=0.0d0
      do i=1,n
         pndtr = 0.5d0*( erf( (resid(iwork(i))-rmean)/std2 ) + 1.0d0 )
         absdev = abs( pndtr - (float(i)-0.5d0 )/fn )
         if (absdev.gt.dks) dks=absdev
      end do
c
      kstestn=probks(dks*sqrt(float(n)))
      return
      end


c----------------------------------------------------------------------
c                    =========================
c                         function PROBKS
c                    =========================
c
c  Calculates the significance factor for a given Kolmogorov-Smirnov
c  statistic using the K-S probability distribution function.
c  From Numerical Recipes, Press et al.
c
      function probks(alam)
      implicit none
      integer j
      double precision a2,alam,fac,probks,term,termbf
c
      double precision EPS1, EPS2
      parameter(EPS1=0.001,EPS2=1.0d-8)
      a2=-2*alam**2
      fac=2.0d0
      probks=0.0d0
      termbf=0.0d0
      do j=1,100
         term=fac*exp(a2*j**2)
         probks=probks+term
         if (abs(term).lt.EPS1*termbf.or.abs(term).lt.EPS2*probks)
     #      return
         termbf=abs(term)
      end do
      probks=1.0d0
      return
      end

c----------------------------------------------------------------------
c                    =========================
c                       subroutine INDEXX
c                    =========================
c
c     Sort indices of elements in a given array according to increasing
c     value using the Heapsort method.
c     From Numerical Recipes, Press et al.
c
c----------------------------------------------------------------------
      subroutine indexx(n,arrin,indx)
      implicit none
      integer n,indx(n)
      double precision arrin(n)
c
      integer i,indxt,ir,j,l
      double precision q
c
      do j=1,n
         indx(j)=j
      end do
      l=n/2+1
      ir=n
 10   continue
         if (l.gt.1) then
            l=l-1
            indxt=indx(l)
            q=arrin(indxt)
	 else
            indxt=indx(ir)
            q=arrin(indxt)
            ir=ir-1
            if (ir.eq.1) then
               indx(1)=indxt
               return
            endif
	 endif
c
         i=l
	 j=l+l
  20     if (j.le.ir) then
            if (j.lt.ir) then
               if (arrin(indx(j)).lt.arrin(indx(j+1))) j=j+1
            endif
            if (q.lt.arrin(indx(j))) then
               indx(i)=indx(j)
               i=j
               j=j+j
            else
               j=ir+1
            endif
            go to 20
         endif
         indx(i)=indxt
      goto 10
      end
