void newwindow( int *n, int *wflag, title label )
{
int wn = *n - 1;

    if ( (wn < n_win) || (wn > n_win+1) || (n_win == MAX_WINDOWS) ) return;

    /* Set display, screen, and colormap for the new window */

    wds[wn].dspy = XOpenDisplay( "" );
    wds[wn].screen = DefaultScreen( wds[wn].dspy );
    wds[wn].map = XDefaultColormap( wds[wn].dspy, wds[wn].screen );

    /* Set default program-specified window position and size */

    sizehints.x = *xloc;
    sizehints.y = *yloc;
    sizehints.width = *ysize;
    sizehints.height = *xsize;
    sizehints.flags = PPosition | PSize;

    /* Create window with properties set in sizehints  */

    wds[wn].wdw = XCreateSimpleWindow(
                         wds[wn].dspy,
                         DefaultRootWindow( wds[wn].dspy ),
                         sizehints.x, sizehints.y,
                         sizehints.width, sizehints.height, NLSL_border,
                         wds[wn].fgnd, wds[wn].bgnd );


       *xloc = sizehints.x = *xloc;
       *yloc = sizehints.y = *yloc;
       *xsize = sizehints.height;
       *ysize = sizehints.width;

      /*
      This interface to the window manager is used in 
      Version 11 Release 4 and earlier 
      */

      XSetStandardProperties( wds[wn].dspy, wds[wn].wdw, label,
                              label, None, "/", 1, &sizehints );

      /* Find color values */

      getNLSLcolor( wds[wn], "orange",  &orange );
      getNLSLcolor( wds[wn], "green",   &green  );
      getNLSLcolor( wds[wn], "magenta", &magenta );
      
      /* Create Graphics Context for the window */

      wds[wn].gc = XCreateGC(wds[wn].dspy, wds[wn].wdw, 0, 0);
      XSetBackground( wds[wn].dspy, wds[wn].gc, black );
      XSetForeground( wds[wn].dspy, wds[wn].gc, white );

      /* Select input events: keypresses, mouse button presses, exposures */

      XSelectInput( wds[wn].dspy, wds[wn].wdw,
		    ButtonPressMask | KeyPressMask | ExposureMask );

      /* Map window "on top of" existing windows */

      XMapRaised( wds[wn].dspy, wds[wn].wdw ); 

      /* Initialize flags and data array pointers */

      wds[wn].show = *wflag;
      wds[wn].expt = wds[wn].diff = wds[wn].scale = NULL;
      for (i=0; i<MAX_SITES; i++) wds[wn].comp[i] = NULL;
      }
