c NLSL Version 1.5 beta 11/23/95
c----------------------------------------------------------------------
c                    ====================
c                     subroutine XSAVE
c                    ====================
c   Saves a copy of the current variable parameters and associated
c   quantities, plus shifting and scaling information for all currently
c   defined sites and series spectra.
c
      subroutine xsave()
      implicit none
c
      include 'nlsdim.inc'
      include 'lmcom.inc'
      include 'parcom.inc'
c
      integer i
c
      do i=1,nprm
         fxsave(1,i)=x(i)
         fxsave(2,i)=xerr(i)
         fxsave(3,i)=prmin(i)
         fxsave(4,i)=prmax(i)
         fxsave(5,i)=prscl(i)
         fxsave(6,i)=xfdstp(i)
         ixsave(1,i)=ixpr(i)
         ixsave(2,i)=ixst(i)
         ixsave(3,i)=ibnd(i)
         tagsav(i)=tag(i)
      end do
      nprsav=nprm
      xsaved=.true.
      return
      end



      subroutine xrest()
      implicit none
c
      include 'nlsdim.inc'
      include 'lmcom.inc'
      include 'parcom.inc'
c
      integer i
c
      if (.not.xsaved) return
      do i=1,nprm
         x(i)=fxsave(1,i)
         xerr(i)=fxsave(2,i)
         prmin(i)=fxsave(3,i)
         prmax(i)=fxsave(4,i)
         prscl(i)=fxsave(5,i)
         xfdstp(i)=fxsave(6,i)
         ixpr(i)=ixsave(1,i)
         ixst(i)=ixsave(2,i)
         ibnd(i)=ixsave(3,i)
         tagsav(i)=tag(i)
      end do
      nprm=nprsav
      return
      end

      subroutine prsave()
      implicit none
c
      include 'nlsdim.inc'
      include 'lmcom.inc'
      include 'parcom.inc'
      include 'expdat.inc'
c
      do i=1,NFPRM
         do j=1,MXSITE
            fprsav(i,j)=fparm(i,j)
            ixxsav(i,j)=ixx(i,j) 
         end do
      end do
c
      do i=1,NIPRM
         do j=1,MXSITE
            iprsav(i,j)=iparm(i,j)
         end do
      end do
      nstsav=nsite
c
      do i=1,MXSPC
         spsave(1,i)=b0(i)
         spsave(2,i)=sphs(i)
         spsave(3,i)=spsi(i)
         spsave(4,i)=slb(i)
      end do
      nsesav=nser
      return
      end
      
