c NLS Version 1.3  7/13/93
c----------------------------------------------------------------------
c                      =====================
c                        subroutine CONVLV
c                      =====================
c
c   Taken from subroutine CONVLV in Numerical Recipes, Press et al.
c   Calculates the convolution function of two input arrays.
c
c
c   Inputs:
c
c     data     Data array (n points)
c
c     respns   Array that is to be convoluted with data (m points)
c
c     n        Number of points in data
c              NOTE: For the FFT, this must be a power of two.
c              This routine does not check for this condition.
c
c     m        Number of points in respns (NOTE: respns should
c              be dimensioned to n!)
c
c     ans      Contains convoluted function (should be dimensioned
c              as complex*16 or twice the size of data array)
c
c     fft      Temporary storage for fft of product function. Should be
c              dimensioned as complex*16 or twice the size of data array)
c
c     Uses:
c       twofft   (from Numerical Recipes)
c       four1    (from Numerical Recipes)
c       realft   (from Numerical Recipes)
c   
c----------------------------------------------------------------------
      subroutine convlv(data,n,respns,m,isign,ans,fft)
      integer isign,m,n
      double precision data(n),respns(n)
      complex*16 ans(n),fft(n)
c
c     USES realft,twofft
c
      integer i,no2
c
      do i=1,(m-1)/2
        respns(n+1-i)=respns(m+1-i)
      end do
c
      do i=(m+3)/2,n-(m-1)/2
        respns(i)=0.0
      end do
c
      call twofft(data,respns,fft,ans,n)
c
      no2=n/2
      if (isign.eq.1) then
         do i=1,no2+1
            ans(i)=fft(i)*ans(i)/no2
         end do
c
      else if (isign.eq.-1) then
         do i=1,no2+1
            if (abs(ans(i)).eq.0.0) pause 'Response zero in CONVLV'
            ans(i)=fft(i)/ans(i)/no2
         end do
c
      else
         pause 'No meaning for isign in CONVLV'
      endif
c
      ans(1)=dcmplx(real(ans(1)),real(ans(no2+1)))
      call realft(ans,n,-1)
      return
      end
