c NLSL Version 1.5 beta 9/13/95
c----------------------------------------------------------------------
c                    =========================
c                       subroutine COVXFRM
c                    =========================
c
c This routine calculates a transformed covariance matrix for a
c set of variables {z_i} different from the set {x_i} used to carry out
c the nonlinear least-squares minimization. 
c
c In the present version, the only different variables allowed are
c the order parameters calculated from the potential coefficients,
c which are often of more direct physical interest..
c
c The transformation is carried out as follows: first, the Jacobian
c matrix T is determined such that Tij = d z_i/d x_i. Then the new
c covariance matrix is calculated as 
c
c                    T
c     Cnew = T Cold T
c
c If a given potential coefficient is in the original list of variable 
c parameters, all of the order parameters up to the L,K value of the 
c coefficient are calculated. Note that this means there can be more 
c "transformed variables" than the original number variable parameters.
c That is, T may not be square.
c----------------------------------------------------------------------
c
c  Largest possible transformation matrix is MXJCOL+4*MXSITE by MXJCOL
c  if only c44 is being varied for each of the maximum number of sites!
c
      subroutine covxfrm
      implicit none

      include 'nlsdim.inc'
      include 'lmcom.inc'

      integer i,j,k,l,iprm,isi,itrv,jc,jr
      double precision tcov(MXTV,MXTV),tmat(MXTV,MXJCOL)

c      Zero transformation matrix
c
      do i=1,MAXTR
         do j=1,MAXTC
            tmat(i,j)=0.0d0
         end do
      end do
c
      itrv=0
      iprm=1

c     For each variable parameter ...

 1    if (iprm.le.nprm) then
c
c        -------------------------------------------------------------
c        If parameter is not a potential coefficient, put it directly
c        into list of "transformed" variables. Corresponding element
c        of Jacobian matrix is one.
c        -------------------------------------------------------------

         if (ixpr(iprm).lt.IC20 .or. ixpr(iprm).gt.IC20+5) then
            itrv=itrv+1
            tmat(itrv,iprm) = 1.0d0
         else
            isi = ixst(iprm)
            call ordrjc( fparm(IC20,isi), s(1,isi), ixx(IC20,isi),
     #                   opjac, jc, jr )
c
c        ------------------------------------------------------------
c        jc should contain the number of potential coeffients for
c        the current site being varied. Check that variable
c        parameter x(iprm+jc-1) is also an order parameter for
c        the current site
c        ------------------------------------------------------------
c
            ichk=iprm+jc-1
            if (ixpr(ichk).lt.IC20 or ixpr(ichk).gt.IC20+5
     #          .or. ixst(ichk).ne.isi) then
               write (luout,1000)
          return
            end if
            do i=1,jr
               do j=1,jc
                  tmat(itrv+i,iprm+j-1) = opjac(i,j)
               end do
            end do
            iprm=iprm+jc
            itrv=itrv+jr
         end if
      end if
      go to 1
c
c      -----------------------------------
c                                       T
c      Transform matrix: Cnew = T Cold T
c      -----------------------------------
c
      do i = 1,jr
         do j=1,jr
            tcov(i,j)=0.0d0
            do k=1,jc
               temp=0.0d0
               do l=1,jc
                  temp=temp+fjac(k,l)*tmat(j,l)
               end do
               tcov(i,j)=tcov(i,j)+tmat(i,k)*temp
            end do
         end do
      end do

      return
c
c ---formats
c
 1000 format('*** Error in construction of covariance transformation',
     #       ' matrix ***')
                     
      end
            

      
c
c
      if (pconvt) then
         find next potential coeff. in parameter list
         isi=site of found coeff
         if (coeff. has not been marked) then
            mark all coefficients for isite (find highest one)
            add all indices up to highest coeff. to convert list
         end if
      end if
c
c  Build Jacobian matrix that will be used to transform
c  the covariance matrix
c
      do ipr=1,nprm




