c NLSL Version 1.5 7/3/95
c----------------------------------------------------------------------
c                    =========================
c                       subroutine LGRID
c                    =========================
c     Carries out a grid search for the minimum of chi-squared function 
c     using the MIN, MAX and NGRID values specified for each variable
c     parameter in the VARY command.
c
c----------------------------------------------------------------------
      subroutine lgrid
      implicit none
c
      integer i,j,igrid
      double precision xmin(MXVAR),chsqmn
c
c     Need to keep the following for each parameter in /parcom/:
c        ngrid, dgrid

      call xsave
      do i=1,nprm
c
c        Check for acceptable min, max, grid number
c
         x(i)=prmin(i)
         dgrid(i)=(prmax(i)-prmin(i))/(ngrid(i)-1)
         igrid(i)=ngrid(i)
      end do
c
c     ------------------------------------
c     Open grid file if one was required
c     ------------------------------------
c
      chsqmn=1.0D0/RNDOFF**2
c
c     ----------------------------
c     Inner loop over value of x(1)
c     ----------------------------
c
      igcnt=0
      igtot=1
      do i=1,nprm
         igtot=igtot*ngrid(i)
      end do
      
 1    x(1)=prmin(1)
      do i=1,ngrid(1)
c
         igcnt=igcnt+1
c
c        --------------------
c        calculate function
c        --------------------
c
c        -----------------------------------------
c        output current grid point and chi squared
c        -----------------------------------------
c
         if (outgrd) write(ludisk,1000) chisq,(x(j),j=1,nprm)
         write(luout,1000) chisq,(x(j),j=1,nprm)
         if (luout.ne.luttyo) write(luttyo,1002) igcnt,igtot
c
c        ------------------------------------- 
c        Save location of minimum chi-squared
c        ------------------------------------- 
c
         if (chisq.lt.chsqmn) then
            do j=1,nprm
               xmin(j)=x(j)
            end do
            chsqmn=chisq
         end if

         x(1)=x(1)+dgrid(1)
      end do
c
      if (nprm.le.1) goto 3
c
c     ----------------------------------------------------
c     Increment succeeding parameter(s) in the search grid
c     ----------------------------------------------------
c
      igptr=2
 2       igrid(igptr)=igrid(igptr)-1
         x(igptr)=x(igptr)+dgrid(igptr)
c
c        ----------------------------------------------------
c        Decrement loop counters for the succeeding parameter
c        ----------------------------------------------------
c
         if (igrid(igptr).le.0) then
c
c           --------------------------------------------------
c           If counter is zero for last parameter, we're done
c           --------------------------------------------------
c
            if (igptr.eq.nprm) goto 3
c
c           --------------------------------------------------
c           Otherwise, a zero resets the range, and we go back
c           and decrement the counter for the next parameter
c           --------------------------------------------------
c
            igrid(igptr)=ngrid(igptr)
            x(igptr)=prmin(igptr)
            igptr=igptr+1
            goto 2
         else
            goto 1
         end if
c
 3    continue
c
c     ---------------------------------
c     Close grid file if one was opened  
c     ---------------------------------
c
      close(ludisk)
c
c     -------------------------------------------
c     Output the minimum chi-squared in the grid
c     -------------------------------------------
c
      write(luout,1001) chsqmn,(tag(j),xmin(j),j=1,nprm)
c
      do j=1,nprm
         x(j)=xmin(j)
      end do
c
      return
      end

         
