c
c----------------------------------------------------------------------
c                    =========================
c                      subroutine ORDRJC
c                    =========================
c
c Calculates the Jacobian matrix of partial derivatives of the
c order parameters with respect to the potential coefficients
c
c  Inputs:
c    cf     Vector of coefficients c20, c22, c40, c42, c44 at which
c           Jacobian is to be calculated
c    d      Vector of order parameters <D20> <D22> <D40> <D42> <D44>
c           corresponding to coefficients in cf
c    mark   Vector of flags indicating wither corresponding element
c           of cf should be included in the Jacobian (0=no, else yes)
c
c  Output:
c
c    opjac  Desired Jacobian. opjac(i,j) is d d(i) / d cf(j). Leading
c           dimension of this array is 5
c
c    nor    Number of rows in opjac
c
c    noc    Number of columns in opjac.
c----------------------------------------------------------------------

      ordrjc( cf, d, mark, opjac, npt, nor )
      implicit none
c
      double precision cf(5),d(5),opjac(5,5)
      integer mark(5), nor, npt
c
      npt=0
      nor=0
      do j=1,5
         if (mark(j).ne.0) then
            npt=npt+1
            nor=j
      end do
c
      do j=1,npt
         if (mark(j).ne.0) then
            tmp = cf(j)
            cf(j)=cf(j)+EPS

            call ordrpr(cf,opjac(1,j))

            do i=1,npt
               opjac(i,j) = (opjac(i,j)-d(i))/EPS
            end do
            cf(j) = tmp
c
         else
            do i=1,npt
               opjac(i,j) = 0.0d0
            end do
         end if
      end do
      
